/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CPFLImpFactory.h,v 1.2 1999/09/17 04:20:44 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CPFLImpFactory_h	// [
#define Included_CPFLImpFactory_h

#include "pgpClassesConfig.h"
#include "CImpFactory.h"

_PGP_BEGIN

// Types

class CFileImp;
class CMutexImp;
class CSemaphoreImp;
class CSpinLockImp;
class CThreadImp;
class CTimerImp;


// Class CPFLImpFactory

class CPFLImpFactory : public CImpFactory
{
	NOT_COPYABLE(CPFLImpFactory)

	DECLARE_SINGLETON_VARIABLE(CPFLImpFactory)

	DECLARE_IMP_NEWFUNCS_PURE(CFileImp, FileImp);
	DECLARE_IMP_NEWFUNCS_PURE(CMutexImp, MutexImp);
	DECLARE_IMP_NEWFUNCS_PURE(CSemaphoreImp, SemaphoreImp);
	DECLARE_IMP_NEWFUNCS_PURE(CSpinLockImp, SpinLockImp);
	DECLARE_IMP_NEWFUNCS_PURE(CThreadImp, ThreadImp);
	DECLARE_IMP_NEWFUNCS_PURE(CTimerImp, TimerImp);

public:
	CPFLImpFactory() { }
	~CPFLImpFactory() { }
};

_PGP_END

#endif	// Included_CPFLImpFactory_h
